/*
 * Monitor.java
 *
 * 
 */
 package DisCSP.DistributedCSP;



/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

import java.net.UnknownHostException;
import java.io.*;

public class Monitor extends Thread
{
	private MonitorServer server;
	private AgentDescriptor[] agents;
	private MonitorState state;


 	/** Costruttore di Monitor
     * 
     * @param addr l'IP del monitor
     * @param port la porta del monitor
     * @param agtAddr l'IP di ogni agente
     * @param agtPort la porta di ogni agente
     * @param ps il PrintStream su cui direzionare l'output
     *
     */	
	public Monitor(String addr,int port,String[] agtAddr, int[] agtPort, PrintStream ps) 
	{
		int agentsNum=agtPort.length;
		
		agents= new AgentDescriptor[agentsNum];
		
		for(int i=0;i<agentsNum;i++)
		{
			agents[i]=new AgentDescriptor(agtAddr[i],agtPort[i],agentsNum);
		}
		
		state= new MonitorState(addr,port);
		server= new MonitorServer(port,agents,state,ps);
		server.start();
		try
		{
			server.join();
		}
		catch(InterruptedException e)
		{
		}
		
	}
}



